<?php

/**
 * Dragonbyte-Tech.com Downloads Mod 1.0.0
 * 
 * @author David Tobin
 * @copyright 2010
 * @version 1.0
 * 
 * You may not copy/reproduce any part of this file in whole or significant part.
 * 
 * All rights reserved.
 */

if ($db_alter->fetch_table_info('language')) {
	$db_alter->add_field(array(
		'name'       => 'phrasegroup_dbtech_downloads',
		'type'       => 'MEDIUMTEXT',
		'null'       => true,	// True = NULL, false = NOT NULL
		'default'    => ''
	));
	//print_mod_message('- Altered Table: <strong><em>' . TABLE_PREFIX . 'language</em></strong>');
}

if ($db_alter->fetch_table_info('usergroup')) {
	$db_alter->add_field(array(
		'name'		=> 'dbtech_downloads_downloadsperday',
		'type'		=> 'INT(5)',
		'null'		=> true,
		'default'	=> '0'
	));
	
	$db_alter->add_field(array(
		'name'		=> 'dbtech_downloads_downloadsizeperday',
		'type'		=> 'INT(30)',
		'null'		=> true,
		'default'	=> '0'
	));
}

if ($db_alter->fetch_table_info('user')) {
	$db_alter->add_field(array(
		'name'		=> 'dbtech_downloads_downloads_today',
		'type'		=> 'INT(10)',
		'null'		=> true,
		'default'	=> '0'
	));
	
	$db_alter->add_field(array(
		'name'		=> 'dbtech_downloads_download_size_today',
		'type'		=> 'INT(20)',
		'null'		=> true,
		'default'	=> '0'
	));
	
	$db_alter->add_field(array(
		'name'		=> 'dbtech_downloads_favourites',
		'type'		=> 'MEDIUMTEXT',
		'null'		=> true
	));
	
	$db_alter->add_field(array(
		'name'		=> 'dbtech_downloads_banned',
		'type'		=> "ENUM('0','1')",
		'null'		=> false,
		'default'	=> '0'
	));
}

$db->query_write("
	DELETE FROM " . TABLE_PREFIX . "phrasetype
	WHERE fieldname = 'dbtech_downloads'
");

$db->query_write("
	INSERT INTO " . TABLE_PREFIX . "phrasetype (fieldname, title, editrows, product) 
	VALUES ('dbtech_downloads', 'Dragonbyte-Tech: Downloads', 3, 'dbtech_downloads')
");

$db->query_write("
	CREATE TABLE IF NOT EXISTS `" . TABLE_PREFIX . "dbtech_downloads_categories` (
		`catid` INT(10) UNSIGNED NOT NULL AUTO_INCREMENT,
		`catname` VARCHAR(300) NOT NULL,
		`catdesc` MEDIUMTEXT NULL,
		`extgroupids` TEXT NULL,
		`private` ENUM('0','1') NOT NULL DEFAULT '0',
		`password` ENUM('0','1') NOT NULL DEFAULT '0',
		`moderation` ENUM('0','1') NOT NULL DEFAULT '0',
		`permissions` MEDIUMTEXT NULL,
		PRIMARY KEY (`catid`)
	)
");

$db->query_write("
	CREATE TABLE IF NOT EXISTS `" . TABLE_PREFIX . "dbtech_downloads_comments` (
		`comid` INT(10) UNSIGNED NOT NULL AUTO_INCREMENT,
		`userid` INT(10) UNSIGNED NOT NULL,
		`fileid` INT(10) UNSIGNED NOT NULL,
		`comment` MEDIUMTEXT NOT NULL,
		`dateline` INT(10) UNSIGNED NOT NULL DEFAULT '0',
		PRIMARY KEY (`comid`)
	)
");

$db->query_write("
	CREATE TABLE IF NOT EXISTS `" . TABLE_PREFIX . "dbtech_downloads_extensions` (
		`extensionid` INT(10) UNSIGNED NOT NULL AUTO_INCREMENT,
		`extension` CHAR(50) NOT NULL,
		`mime` CHAR(100) NOT NULL,
		`maxsize` INT(20) UNSIGNED NOT NULL DEFAULT '0',
		`maxheight` INT(10) UNSIGNED NOT NULL DEFAULT '0',
		`maxwidth` INT(10) UNSIGNED NOT NULL DEFAULT '0',
		`image` INT(20) UNSIGNED NOT NULL DEFAULT '0',
		`extgroupid` INT(10) UNSIGNED NOT NULL,
		PRIMARY KEY (`extensionid`)
	)
");

$db->query_write("
	CREATE TABLE IF NOT EXISTS `" . TABLE_PREFIX . "dbtech_downloads_extension_groups` (
		`extgroupid` INT(10) UNSIGNED NOT NULL AUTO_INCREMENT,
		`groupname` CHAR(200) NOT NULL,
		PRIMARY KEY (`extgroupid`)
	)
");

$db->query_write("
	CREATE TABLE IF NOT EXISTS `" . TABLE_PREFIX . "dbtech_downloads_filegroup` (
		`groupid` INT(10) UNSIGNED NOT NULL AUTO_INCREMENT,
		`userid` INT(20) UNSIGNED NOT NULL DEFAULT '0',
		`groupname` VARCHAR(300) NOT NULL,
		`groupdesc` MEDIUMTEXT NULL,
		`downloads` INT(15) UNSIGNED NOT NULL DEFAULT '0',
		`files` MEDIUMTEXT NULL,
		`filecount` INT(5) UNSIGNED NOT NULL DEFAULT '0',
		`image` SMALLINT(10) NULL DEFAULT '0',
		`rating` INT(11) NOT NULL DEFAULT '0',
		`updated` INT(10) UNSIGNED NOT NULL DEFAULT '0',
		`categoryid` INT(20) NOT NULL,
		`moderation` ENUM('0','1') NOT NULL DEFAULT '0',
		`password` CHAR(250) NULL DEFAULT NULL,
		`private` MEDIUMTEXT NULL,
		`favourites` INT(10) NULL DEFAULT '0',
		`mirrors` MEDIUMTEXT NULL DEFAULT NULL,
		PRIMARY KEY (`groupid`),
		INDEX `userid` (`userid`)
	)
");

$db->query_write("
	CREATE TABLE IF NOT EXISTS `" . TABLE_PREFIX . "dbtech_downloads_filehash` (
		`hashid` INT(10) UNSIGNED NOT NULL AUTO_INCREMENT,
		`fileid` INT(10) UNSIGNED NOT NULL,
		`md5` CHAR(50) NOT NULL,
		PRIMARY KEY (`hashid`)
	)
");

$db->query_write("
	CREATE TABLE IF NOT EXISTS `" . TABLE_PREFIX . "dbtech_downloads_fileinfo` (
		`fileid` INT(20) UNSIGNED NOT NULL AUTO_INCREMENT,
		`userid` INT(20) UNSIGNED NOT NULL DEFAULT '0',
		`filename` VARCHAR(1000) NOT NULL,
		`dateline` INT(20) UNSIGNED NOT NULL DEFAULT '0',
		`filesize` INT(20) UNSIGNED NOT NULL DEFAULT '0',
		`filetype` CHAR(50) NULL DEFAULT NULL,
		`private` ENUM('0','1') NOT NULL DEFAULT '0',
		`privateusers` VARCHAR(5000) NULL DEFAULT NULL,
		`downloads` SMALLINT(50) UNSIGNED NOT NULL DEFAULT '0',
		`image` TINYINT(1) UNSIGNED NOT NULL DEFAULT '0',
		`parentid` SMALLINT(50) UNSIGNED NOT NULL,
		PRIMARY KEY (`fileid`)
	)
");

$db->query_write("
	CREATE TABLE IF NOT EXISTS `" . TABLE_PREFIX . "dbtech_downloads_modules` (
		`moduleid` CHAR(100) NOT NULL,
		`permissions` MEDIUMTEXT NULL,
		`enabled` ENUM('0','1') NOT NULL DEFAULT '1',
		PRIMARY KEY (`moduleid`)
	)
");

$db->query_write("
	CREATE TABLE IF NOT EXISTS `" . TABLE_PREFIX . "dbtech_downloads_ratings` (
		`ratingid` INT(10) UNSIGNED NOT NULL AUTO_INCREMENT,
		`fileid` INT(10) UNSIGNED NOT NULL,
		`userid` INT(10) UNSIGNED NOT NULL,
		PRIMARY KEY (`ratingid`)
	)
");

$db->query_write("
	CREATE TABLE IF NOT EXISTS `" . TABLE_PREFIX . "dbtech_downloads_report` (
		`reportid` INT(10) UNSIGNED NOT NULL AUTO_INCREMENT,
		`type` CHAR(20) NOT NULL,
		`userid` INT(20) UNSIGNED NOT NULL,
		`targetid` INT(20) UNSIGNED NOT NULL,
		`reason` INT(2) UNSIGNED NOT NULL,
		`dateline` INT(20) UNSIGNED NOT NULL DEFAULT '0',
		PRIMARY KEY (`reportid`)
	)
");

$db->query_write("DELETE FROM " . TABLE_PREFIX . "dbtech_downloads_extensions");
$db->query_write("DELETE FROM " . TABLE_PREFIX . "dbtech_downloads_extension_groups");
$db->query_write("DELETE FROM " . TABLE_PREFIX . "dbtech_downloads_categories");

$db->query_write("INSERT INTO `" . TABLE_PREFIX . "dbtech_downloads_extensions` (`extensionid`, `extension`, `mime`, `maxsize`, `maxheight`, `maxwidth`, `image`, `extgroupid`) VALUES (1, 'png', 'image/png', 5242880, 1000, 700, 1, 1);");
$db->query_write("INSERT INTO `" . TABLE_PREFIX . "dbtech_downloads_extensions` (`extensionid`, `extension`, `mime`, `maxsize`, `maxheight`, `maxwidth`, `image`, `extgroupid`) VALUES (2, 'gif', 'image/gif', 5242880, 1000, 700, 1, 1);");
$db->query_write("INSERT INTO `" . TABLE_PREFIX . "dbtech_downloads_extensions` (`extensionid`, `extension`, `mime`, `maxsize`, `maxheight`, `maxwidth`, `image`, `extgroupid`) VALUES (3, 'jpeg', 'image/jpeg', 5242880, 1000, 700, 1, 1);");
$db->query_write("INSERT INTO `" . TABLE_PREFIX . "dbtech_downloads_extensions` (`extensionid`, `extension`, `mime`, `maxsize`, `maxheight`, `maxwidth`, `image`, `extgroupid`) VALUES (10, 'avi', 'video/x-msvideo', 5242880, 0, 0, 0, 3);");
$db->query_write("INSERT INTO `" . TABLE_PREFIX . "dbtech_downloads_extensions` (`extensionid`, `extension`, `mime`, `maxsize`, `maxheight`, `maxwidth`, `image`, `extgroupid`) VALUES (5, 'zip', 'application/zip', 5242880, 0, 0, 0, 2);");
$db->query_write("INSERT INTO `" . TABLE_PREFIX . "dbtech_downloads_extensions` (`extensionid`, `extension`, `mime`, `maxsize`, `maxheight`, `maxwidth`, `image`, `extgroupid`) VALUES (7, 'jpg', 'image/jpeg', 5242880, 1000, 700, 1, 1);");
$db->query_write("INSERT INTO `" . TABLE_PREFIX . "dbtech_downloads_extensions` (`extensionid`, `extension`, `mime`, `maxsize`, `maxheight`, `maxwidth`, `image`, `extgroupid`) VALUES (11, 'mpeg', 'video/mpeg', 5242880, 0, 0, 0, 3);");
$db->query_write("INSERT INTO `" . TABLE_PREFIX . "dbtech_downloads_extensions` (`extensionid`, `extension`, `mime`, `maxsize`, `maxheight`, `maxwidth`, `image`, `extgroupid`) VALUES (12, 'pdf', 'application/pdf', 5242880, 0, 0, 0, 2);");

$db->query_write("INSERT INTO `" . TABLE_PREFIX . "dbtech_downloads_extension_groups` (`extgroupid`, `groupname`) VALUES (1, 'Images');");
$db->query_write("INSERT INTO `" . TABLE_PREFIX . "dbtech_downloads_extension_groups` (`extgroupid`, `groupname`) VALUES (2, 'Files');");
$db->query_write("INSERT INTO `" . TABLE_PREFIX . "dbtech_downloads_extension_groups` (`extgroupid`, `groupname`) VALUES (3, 'Videos');");

$db->query_write("INSERT INTO `" . TABLE_PREFIX . "dbtech_downloads_categories` (catname, catdesc) VALUES ('Default Category', 'Category added at installation')");

?>